<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuração de conexão com o banco de dados
$servername = "149.56.34.221";
$username = "inventario";
$password = "Inventario@2024";
$dbname = "ozpet_campo_limpo_dev";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Erro na conexão com o banco de dados.']);
    exit;
}

// Receber o JSON enviado pela requisição
$data = json_decode(file_get_contents('php://input'), true);
$barcode = $data['barcode'] ?? '';
$auditorName = $data['auditor_name'] ?? '';

if (empty($barcode)) {
    echo json_encode(['success' => false, 'message' => 'Código de barras vazio.']);
    exit;
}

// Verificar se o código de barras já existe
$query = "SELECT auditor_name, finalizado FROM inventory WHERE barcode = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $barcode);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // O código já existe
    $row = $result->fetch_assoc();

    if ($row['finalizado'] == 1) {
        // Código já foi finalizado
        echo json_encode(['success' => false, 'message' => 'Código já Finalizado, Chamar Conferente']);
    } elseif ($row['auditor_name'] !== $auditorName) {
        // Código está associado a outro auditor
        echo json_encode(['success' => false, 'message' => "Erro: Já está com outro auditor: " . $row['auditor_name']]);
    } else {
        // Código pertence ao mesmo auditor, permitir a contagem
        echo json_encode(['success' => true]);
    }
} else {
    // O código não existe: insira um novo registro
    $insert_query = "INSERT INTO inventory (barcode, quantity, auditor_name, finalizado) VALUES (?, 1, ?, 0)";
    $insert_stmt = $conn->prepare($insert_query);
    $insert_stmt->bind_param("ss", $barcode, $auditorName);
    if ($insert_stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Código de barras inserido com sucesso.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao inserir o novo código de barras.']);
    }
    $insert_stmt->close();
}

$stmt->close();
$conn->close();
?>
